/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class DwarfSprucePlantBlock
extends DwarfSpruceBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    private static final Map<Supplier<? extends Item>, Block> TORCH_SPRUCES = Maps.newHashMap();
    private final DwarfSpruceHeadBlock headBlock;

    public DwarfSprucePlantBlock(BlockBehaviour.Properties properties, DwarfSpruceHeadBlock headBlock) {
        this(properties, (Supplier<Item>)null, headBlock);
    }

    public DwarfSprucePlantBlock(BlockBehaviour.Properties properties, ResourceLocation torch, DwarfSpruceHeadBlock headBlock) {
        this(properties, () -> (Item)ForgeRegistries.ITEMS.getValue(torch), headBlock);
    }

    public DwarfSprucePlantBlock(BlockBehaviour.Properties properties, Supplier<Item> torch, DwarfSpruceHeadBlock headBlock) {
        super(properties, torch);
        this.headBlock = headBlock;
        this.headBlock.setBodyBlock(this);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item getTorch() {
        return this.torch == null ? null : (Item)this.torch.get();
    }

    @Override
    public Map<Supplier<? extends Item>, Block> getTorchSpruces() {
        return TORCH_SPRUCES;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return direction == Direction.UP && !DwarfSprucePlantBlock.isValidAboveBlock(offsetState) ? this.getHeadState(state) : state;
    }

    protected BlockState getHeadState(BlockState originalState) {
        return (BlockState)this.headBlock.m_49966_().m_61124_((Property)DwarfSpruceHeadBlock.TOP, (Comparable)Boolean.valueOf((Boolean)originalState.m_61143_((Property)BOTTOM) == false));
    }

    @Override
    public BlockState getWithoutTorchesState(BlockState state) {
        return (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()).m_49966_().m_61124_((Property)BOTTOM, (Comparable)((Boolean)state.m_61143_((Property)BOTTOM)));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        BlockPos headpos = DwarfSprucePlantBlock.getHeadPos((BlockGetter)level, pos);
        return headpos != null && level.m_8055_(headpos.m_7494_()).m_60795_();
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos headpos = DwarfSprucePlantBlock.getHeadPos((BlockGetter)level, pos);
        if (headpos != null) {
            BlockState headstate = level.m_8055_(headpos);
            ((DwarfSpruceHeadBlock)headstate.m_60734_()).m_214148_(level, random, headpos, headstate);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOTTOM});
    }
}

