/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.renderer.entity.layers.BackpackOverlayRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.BackpackRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.OverlayRenderLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.SweaterRenderLayer;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlabfishRenderer
extends MobRenderer<Slabfish, SlabfishModel<Slabfish>> {
    public SlabfishRenderer(EntityRendererProvider.Context context) {
        super(context, new SlabfishModel(context.m_174023_(EnvironmentalModelLayers.SLABFISH)), 0.3f);
        this.m_115326_(new SweaterRenderLayer(this));
        this.m_115326_(new BackpackRenderLayer(this));
        this.m_115326_(new OverlayRenderLayer(this));
        this.m_115326_(new BackpackOverlayRenderLayer(this));
    }

    public ResourceLocation getTextureLocation(Slabfish slabby) {
        return SlabfishSpriteUploader.ATLAS_LOCATION;
    }

    protected RenderType getRenderType(Slabfish slabby, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation texture = this.getTextureLocation(slabby);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)texture);
        }
        if (p_230496_2_) {
            return slabby.getSlabfishType().translucent(slabby.m_9236_()) ? RenderType.m_110473_((ResourceLocation)texture) : ((SlabfishModel)this.f_115290_).m_103119_(texture);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)texture) : null;
    }

    protected float getBob(Slabfish livingBase, float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.wingRotation);
        float f1 = Mth.m_14179_((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.destPos);
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }

    protected void scale(Slabfish slabfish, PoseStack matrixStack, float partialTickTime) {
        ((SlabfishModel)this.f_115290_).sprite = SlabfishSpriteUploader.instance().m_118901_(slabfish.getSlabfishType().texture());
        if (slabfish.m_21825_() || slabfish.m_20202_() != null) {
            matrixStack.m_252880_(0.0f, slabfish.m_6162_() ? 0.15625f : 0.3125f, 0.0f);
        }
        if (slabfish.m_20069_()) {
            matrixStack.m_85837_(0.0, -0.35, slabfish.m_6162_() ? 0.25 : 0.5);
            matrixStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
        }
    }
}

