/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.attributefilter;

import com.hlysine.create_connected.CCItemAttributes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemIdAttribute
implements ItemAttribute {
    String word;

    public ItemIdAttribute(String word) {
        this.word = word;
    }

    public boolean appliesTo(ItemStack stack, Level world) {
        return stack.m_41720_().toString().contains(this.word);
    }

    public ItemAttributeType getType() {
        return CCItemAttributes.ID_CONTAINS;
    }

    public String getTranslationKey() {
        return "id_contains";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.word};
    }

    public void save(CompoundTag nbt) {
        nbt.m_128359_("keyword", this.word);
    }

    public void load(CompoundTag nbt) {
        this.word = nbt.m_128461_("keyword");
    }

    public static class LegacyDeserializer
    implements ItemAttribute.LegacyDeserializer {
        public String getNBTKey() {
            return "word";
        }

        public ItemAttribute readNBT(CompoundTag nbt) {
            ItemIdAttribute attribute = new ItemIdAttribute("dummy");
            attribute.load(nbt);
            return attribute;
        }
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemIdAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            String[] words = stack.m_41720_().toString().split("_");
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (String word : words) {
                if (word.length() <= 2) continue;
                attributes.add(new ItemIdAttribute(word));
            }
            return attributes;
        }
    }
}

