/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pyzpre.createbitterballen.entity.HerringEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HerringModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("modid", "herring"), "main");
    private final ModelPart HerringBackBody;
    private final ModelPart HerringBackFins;
    private final ModelPart HerringBodyBack;
    private final ModelPart HerringBody;
    private static final Logger LOGGER = LogManager.getLogger();

    public HerringModel(ModelPart root) {
        this.HerringBackBody = root.m_171324_("HerringBackBody");
        this.HerringBackFins = root.m_171324_("HerringBackFins");
        this.HerringBodyBack = root.m_171324_("HerringBodyBack");
        this.HerringBody = root.m_171324_("HerringBody");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition HerringBackBody = partdefinition.m_171599_("HerringBackBody", CubeListBuilder.m_171558_().m_171514_(20, 10).m_171488_(-0.5f, -2.0f, 5.0E-4f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)23.0f, (float)12.0f));
        PartDefinition HerringBackFins = partdefinition.m_171599_("HerringBackFins", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(0.0f, -1.5f, 1.0015f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 24).m_171488_(0.0f, 0.5f, 2.0015f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 15).m_171488_(0.0f, -2.5f, 2.0015f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)23.0f, (float)12.0f));
        PartDefinition HerringBodyBack = partdefinition.m_171599_("HerringBodyBack", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.5f, 1.0f, 0.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(18, 24).m_171488_(0.0f, 2.0f, 1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 12).m_171488_(0.0f, -4.0f, 1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)23.0f, (float)5.0f));
        PartDefinition HerringBody = partdefinition.m_171599_("HerringBody", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.5f, -2.0f, -7.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(18, 18).m_171488_(-1.5f, 1.0f, -6.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(20, 5).m_171488_(-1.0f, -2.0f, -9.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)23.0f, (float)6.0f));
        PartDefinition HerringFinLeft_r1 = HerringBody.m_171599_("HerringFinLeft_r1", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)2.5307f));
        PartDefinition HerringFinRight_r1 = HerringBody.m_171599_("HerringFinRight_r1", CubeListBuilder.m_171558_().m_171514_(20, 15).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backFinsYRot;
        float backBodyYRot;
        float bodyYRot;
        float cycle;
        if (!(entity instanceof HerringEntity)) {
            return;
        }
        HerringEntity herring = (HerringEntity)entity;
        this.HerringBody.m_171327_(0.0f, 0.0f, 0.0f);
        this.HerringBackBody.m_171327_(0.0f, 0.0f, 0.0f);
        this.HerringBackFins.m_171327_(0.0f, 0.0f, 0.0f);
        this.HerringBodyBack.m_171327_(0.0f, 0.0f, 0.0f);
        float degToRad = (float)Math.PI / 180;
        if (herring.m_6069_()) {
            float animationSpeed = 5.0f;
            cycle = ageInTicks / animationSpeed % 1.0f;
            bodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -10.0f, 0.0f, 10.0f, 0.0f);
            backBodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -40.0f, 0.0f, 40.0f, 0.0f);
            backFinsYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -40.0f, 0.0f, 40.0f, 0.0f);
            this.HerringBody.f_104204_ = bodyYRot * degToRad;
            this.HerringBackBody.f_104204_ = backBodyYRot * degToRad;
            this.HerringBackFins.f_104204_ = backFinsYRot * degToRad;
        }
        if (!herring.isInFluidType()) {
            this.HerringBody.f_104205_ = 90.0f * degToRad;
            this.HerringBackBody.f_104205_ = 90.0f * degToRad;
            this.HerringBackFins.f_104205_ = 90.0f * degToRad;
            this.HerringBodyBack.f_104205_ = 90.0f * degToRad;
            float landAnimationSpeed = 8.0f;
            cycle = ageInTicks / landAnimationSpeed % 1.0f;
            bodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -5.0f, 0.0f, 5.0f, 0.0f);
            backBodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -20.0f, 0.0f, 20.0f, 0.0f);
            backFinsYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -20.0f, 0.0f, 20.0f, 0.0f);
            this.HerringBody.f_104204_ = bodyYRot * degToRad;
            this.HerringBackBody.f_104204_ = backBodyYRot * degToRad;
            this.HerringBackFins.f_104204_ = backFinsYRot * degToRad;
        }
    }

    private float interpolateKeyframes(float cycle, float k0, float k1, float k2, float k3, float k4, float v0, float v1, float v2, float v3, float v4) {
        float value;
        if (cycle < k1) {
            float t = (cycle - k0) / (k1 - k0);
            value = Mth.m_14179_((float)t, (float)v0, (float)v1);
        } else if (cycle < k2) {
            float t = (cycle - k1) / (k2 - k1);
            value = Mth.m_14179_((float)t, (float)v1, (float)v2);
        } else if (cycle < k3) {
            float t = (cycle - k2) / (k3 - k2);
            value = Mth.m_14179_((float)t, (float)v2, (float)v3);
        } else {
            float t = (cycle - k3) / (k4 - k3);
            value = Mth.m_14179_((float)t, (float)v3, (float)v4);
        }
        return value;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.HerringBackBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.HerringBackFins.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.HerringBodyBack.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.HerringBody.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

