/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.registries;

import com.simibubi.create.foundation.damageTypes.DamageTypeBuilder;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class CMDamageTypes {
    public static final ResourceKey<DamageType> GRINDER = CMDamageTypes.key("mechanical_grinder");
    public static final ResourceKey<DamageType> MOLTEN_FLUID = CMDamageTypes.key("molten_fluid");
    public static final ResourceKey<DamageType> FOUNDRY = CMDamageTypes.key("crucible");

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)CreateMetallurgy.genRL(name));
    }

    public static void bootstrap(BootstapContext<DamageType> ctx) {
        new DamageTypeBuilder(GRINDER).register(ctx);
        new DamageTypeBuilder(MOLTEN_FLUID).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
        new DamageTypeBuilder(FOUNDRY).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_246971_(key));
    }

    public static DamageSource grinder(Level level) {
        return CMDamageTypes.source(GRINDER, (LevelReader)level);
    }

    public static DamageSource moltenFluid(Level level) {
        return CMDamageTypes.source(MOLTEN_FLUID, (LevelReader)level);
    }

    public static DamageSource foundry(Level level) {
        return CMDamageTypes.source(FOUNDRY, (LevelReader)level);
    }
}

