/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.ponders;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.basin.CastingBasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.table.CastingTableBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMFluids;
import fr.lucreeper74.createmetallurgy.registries.CMItems;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CastingScenes {
    public static void castingBlocks(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("casting_blocks", "Casting Molten Metals");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos basinPos = util.grid().at(3, 1, 2);
        BlockPos tablePos = util.grid().at(1, 1, 2);
        BlockPos tankPos = util.grid().at(2, 0, 5);
        BlockPos leverPos = util.grid().at(2, 1, 1);
        BlockPos tableFunnelPos = tablePos.m_122012_();
        BlockPos basinFunnelPos = basinPos.m_122012_();
        Selection basin = util.select().position(basinPos);
        Selection table = util.select().position(tablePos);
        Selection funnelBasin = util.select().position(basinPos.m_122012_());
        Selection funnelTable = util.select().position(tablePos.m_122012_());
        Vec3 tableTop = util.vector().topOf(tablePos);
        Vec3 basinTop = util.vector().topOf(basinPos);
        scene.world().showSection(util.select().fromTo(2, 0, 5, 2, 2, 5), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 1, 4), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 3, 1, 3), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(3, 1, 4), Direction.NORTH);
        scene.world().showSection(util.select().fromTo(3, 0, 5, 3, 1, 5), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(basin, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(table, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showOutline(PonderPalette.WHITE, new Object(), basin, 80);
        scene.overlay().showOutline(PonderPalette.WHITE, new Object(), table, 80);
        scene.overlay().showText(80).attachKeyFrame().text("Casting Blocks can be used to cool down Molten Metals into a specific shape").pointAt(tableTop).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().text("The Casting Basin is used to cast up to a entire block").pointAt(basinTop).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().text("While the Casting Table is used to cast Items using Graphite Molds").pointAt(tableTop).placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(tableTop, Pointing.LEFT, 30).rightClick().withItem(CMItems.GRAPHITE_INGOT_MOLD.asStack());
        scene.idle(7);
        scene.world().modifyBlockEntity(tablePos, CastingTableBlockEntity.class, be -> be.moldInv.insertItem(0, CMItems.GRAPHITE_INGOT_MOLD.asStack(), false));
        scene.idle(20);
        FluidStack brass = new FluidStack(FluidHelper.convertToStill((Fluid)((Fluid)CMFluids.MOLTEN_BRASS.get())), 24000);
        ItemStack ingot = AllItems.BRASS_INGOT.asStack();
        ItemStack block = AllBlocks.BRASS_BLOCK.asStack();
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().fill(brass, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(40);
        scene.world().modifyBlockEntity(tablePos, CastingTableBlockEntity.class, CastingBlockEntity::startProcess);
        scene.world().modifyBlockEntity(basinPos, CastingBasinBlockEntity.class, CastingBlockEntity::startProcess);
        scene.idle(60);
        scene.world().modifyBlockEntity(tablePos, CastingTableBlockEntity.class, be -> be.inv.setStackInSlot(0, ingot));
        scene.world().modifyBlockEntity(tablePos, CastingTableBlockEntity.class, CastingBlockEntity::reset);
        scene.world().modifyBlockEntity(basinPos, CastingBasinBlockEntity.class, be -> be.inv.setStackInSlot(0, block));
        scene.world().modifyBlockEntity(basinPos, CastingBasinBlockEntity.class, CastingBlockEntity::reset);
        scene.idle(5);
        scene.overlay().showControls(tableTop, Pointing.DOWN, 30).withItem(ingot);
        scene.overlay().showControls(basinTop, Pointing.DOWN, 30).withItem(block);
        scene.idle(20);
        scene.world().showSection(util.select().position(leverPos), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(funnelBasin, Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(funnelTable, Direction.SOUTH);
        scene.idle(10);
        Vec3 filter = util.vector().topOf(tableFunnelPos).m_82520_(0.0, -0.3125, -0.09375);
        scene.overlay().showText(80).attachKeyFrame().text("If you are using Funnels instead of manually...").pointAt(tableTop).placeNearTarget();
        scene.idle(90);
        scene.overlay().showFilterSlotInput(filter, Direction.NORTH, 80);
        scene.overlay().showText(80).attachKeyFrame().text("...you might need a Brass Funnel to not extract Molds").pointAt(filter).placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(filter, Pointing.LEFT, 30).rightClick().withItem(ingot);
        scene.idle(7);
        scene.world().setFilterData(funnelTable, FunnelBlockEntity.class, ingot);
        scene.idle(5);
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyBlock(leverPos, s -> (BlockState)s.m_61122_((Property)LeverBlock.f_54622_), false);
        scene.world().modifyBlock(basinFunnelPos, s -> (BlockState)s.m_61122_((Property)FunnelBlock.POWERED), false);
        scene.world().modifyBlock(tableFunnelPos, s -> (BlockState)s.m_61122_((Property)FunnelBlock.POWERED), false);
        scene.world().flapFunnel(basinFunnelPos, true);
        scene.world().createItemEntity(util.vector().centerOf(basinFunnelPos), util.vector().of(0.0, 0.0, 0.0), block);
        scene.world().modifyBlockEntity(basinPos, CastingBasinBlockEntity.class, be -> be.inv.m_6211_());
        scene.world().flapFunnel(tableFunnelPos, true);
        scene.world().createItemEntity(util.vector().centerOf(tableFunnelPos), util.vector().of(0.0, 0.0, 0.0), ingot);
        scene.world().modifyBlockEntity(tablePos, CastingTableBlockEntity.class, be -> be.inv.m_6211_());
    }
}

