/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.data.CMGenEntriesProvider;
import fr.lucreeper74.createmetallurgy.data.recipes.CMProcessingRecipesGen;
import fr.lucreeper74.createmetallurgy.data.recipes.createmetallurgy.CastingRecipeGen;
import fr.lucreeper74.createmetallurgy.data.recipes.createmetallurgy.FoundryRecipeGen;
import fr.lucreeper74.createmetallurgy.data.recipes.vanilla.CMStandardRecipeGen;
import fr.lucreeper74.createmetallurgy.ponders.CMPonders;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;

public class CMDatagen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CMDatagen.addExtraRegistrateData();
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new CMStandardRecipeGen(output));
            gen.addProvider(true, (DataProvider)new CastingRecipeGen(output));
            gen.addProvider(true, (DataProvider)new FoundryRecipeGen(output));
            CMProcessingRecipesGen.registerAll(gen, output);
            gen.addProvider(event.includeServer(), (DataProvider)new CMGenEntriesProvider(output, event.getLookupProvider()));
        }
    }

    private static void addExtraRegistrateData() {
        CreateMetallurgy.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CMDatagen.provideDefaultLang("interface", langConsumer);
            CMDatagen.provideDefaultLang("tooltips", langConsumer);
            CMDatagen.providePonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/createmetallurgy/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new CMPonders());
        PonderIndex.getLangAccess().provideLang("createmetallurgy", consumer);
    }
}

