/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry;

import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MeltingInventory
implements IItemHandlerModifiable {
    private final CrucibleBlockEntity be;
    protected int firstLimitedSlot;
    private final MeltingSlot[] slots;

    public MeltingInventory(CrucibleBlockEntity be, int maxSize) {
        this.firstLimitedSlot = maxSize;
        this.slots = new MeltingSlot[maxSize];
        this.be = be;
    }

    public void setFirstLimitedSlot(int slot) {
        this.firstLimitedSlot = slot;
    }

    public int getSlots() {
        return this.firstLimitedSlot;
    }

    public boolean isAccessible(int slot) {
        return slot >= 0 && slot < this.firstLimitedSlot;
    }

    public MeltingSlot getSlot(int slot) {
        if (slot >= this.firstLimitedSlot) {
            throw new IndexOutOfBoundsException();
        }
        if (this.slots[slot] == null) {
            this.slots[slot] = new MeltingSlot(this.be);
        }
        return this.slots[slot];
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        MeltingSlot meltingSlot;
        if (this.isAccessible(slot) && (meltingSlot = this.getSlot(slot)) != null) {
            return meltingSlot.getStack();
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            this.getSlot(slot).setStack(ItemStack.f_41583_);
        } else {
            if (stack.m_41613_() > 1) {
                stack.m_41764_(1);
            }
            this.getSlot(slot).setStack(stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isAccessible(slot)) {
            return stack;
        }
        if (stack.m_41619_()) {
            return stack;
        }
        boolean canInsert = this.getStackInSlot(slot).m_41619_();
        if (canInsert && !simulate) {
            this.setStackInSlot(slot, stack.m_41777_());
        }
        return canInsert ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1)) : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.isAccessible(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return stackInSlot.m_41777_();
        }
        this.setStackInSlot(slot, ItemStack.f_41583_);
        return stackInSlot;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.firstLimitedSlot = nbt.m_128451_("LimitedSlot");
        ListTag list = nbt.m_128437_("MeltingSlots", 10);
        for (int i = 0; i < list.size(); ++i) {
            int slot;
            CompoundTag item = list.m_128728_(i);
            if (!item.m_128425_("Slot", 3) || !this.isAccessible(slot = item.m_128451_("Slot"))) continue;
            this.getSlot(slot).deserializeNBT(item);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("LimitedSlot", this.firstLimitedSlot);
        ListTag list = new ListTag();
        for (int i = 0; i < this.slots.length; ++i) {
            MeltingSlot meltingSlot = this.slots[i];
            if (meltingSlot == null) continue;
            CompoundTag slotNbt = meltingSlot.serializeNBT();
            slotNbt.m_128405_("Slot", i);
            list.add((Object)slotNbt);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_("MeltingSlots", (Tag)list);
        }
        return nbt;
    }
}

