/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlockLockSlot;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingFluidTank;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipe;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public abstract class CastingBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected ScrollOptionBehaviour<LockMode> lockSelect;
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public CastingFluidTank inputTank;
    private final LazyOptional<CastingFluidTank> fluidCapability;
    public SmartInventory inv = new SmartInventory(1, (SyncedBlockEntity)this, 1, true).forbidInsertion();
    public SmartInventory moldInv = new SmartInventory(1, (SyncedBlockEntity)this, 1, true);
    protected CastingRecipe currentRecipe;
    protected FluidStack fluidBuffer;
    public boolean running;
    public int processingTick;
    public int totalProcessTicks;
    public ItemStack lastOutput;

    public CastingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inv, this.moldInv}));
        this.fluidCapability = LazyOptional.of(() -> this.inputTank);
        this.inputTank = new CastingFluidTank(this);
        this.fluidBuffer = FluidStack.EMPTY;
        this.lastOutput = ItemStack.f_41583_;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.lockSelect = new ScrollOptionBehaviour(LockMode.class, (Component)CMLang.translateDirect("casting.lock_mode", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new CastingBlockLockSlot());
        behaviours.add((BlockEntityBehaviour)this.lockSelect);
        this.lockSelect.withCallback(setting -> {
            boolean isLocked = setting == 1;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CastingBlock.LOCKED, (Comparable)Boolean.valueOf(isLocked)), 2);
            if (isLocked) {
                this.moldInv.forbidExtraction();
            } else {
                this.moldInv.allowExtraction();
            }
        });
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("moldInv", (Tag)this.moldInv.serializeNBT());
        compound.m_128365_("inv", (Tag)this.inv.serializeNBT());
        compound.m_128365_("inputTank", (Tag)this.inputTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("fluidBuffer", (Tag)this.fluidBuffer.writeToNBT(new CompoundTag()));
        compound.m_128365_("lastOutput", (Tag)this.lastOutput.serializeNBT());
        compound.m_128405_("castingTime", this.processingTick);
        compound.m_128405_("totalTime", this.processingTick);
        compound.m_128379_("running", this.running);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.moldInv.deserializeNBT(compound.m_128469_("moldInv"));
        this.inv.deserializeNBT(compound.m_128469_("inv"));
        this.inputTank.readFromNBT(compound.m_128469_("inputTank"), clientPacket);
        this.fluidBuffer = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluidBuffer"));
        this.lastOutput = ItemStack.m_41712_((CompoundTag)compound.m_128469_("lastOutput"));
        this.processingTick = compound.m_128451_("castingTime");
        this.totalProcessTicks = compound.m_128451_("totalTime");
        this.running = compound.m_128471_("running");
    }

    public void readOnlyItems(CompoundTag compound) {
        this.inv.deserializeNBT(compound.m_128469_("inv"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.moldInv);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        this.inputTank.tick();
        if (!this.f_58857_.f_46443_ && !this.running) {
            this.processingTick = -1;
            this.startProcess();
        }
        if (this.running) {
            List<Recipe<?>> recipes;
            if (this.currentRecipe == null && !(recipes = this.getMatchingRecipes()).isEmpty()) {
                this.currentRecipe = (CastingRecipe)recipes.get(0);
            }
            if (!this.f_58857_.f_46443_) {
                if (this.canProcess()) {
                    if (this.processingTick <= 0) {
                        this.process();
                    }
                } else {
                    this.reset();
                }
            } else {
                this.spawnParticles();
            }
            if (this.processingTick >= 0) {
                this.processingTick = CastingBlockEntity.isInAirCurrent(this.m_58904_(), this.m_58899_(), (BlockEntity)this) ? (this.processingTick -= 2) : --this.processingTick;
            }
        }
    }

    public void startProcess() {
        if (this.running && this.processingTick > 0) {
            return;
        }
        if (this.canProcess()) {
            this.processingTick = this.currentRecipe.getProcessingDuration();
            this.running = true;
            this.sendData();
        }
    }

    public void process() {
        FluidStack fluidInTank = this.getFluidTank().getFluidInTank(0);
        this.inv.setStackInSlot(0, this.currentRecipe.m_8043_(this.m_58904_().m_9598_()).m_41777_());
        fluidInTank.shrink(this.currentRecipe.getFluidIngredient().getRequiredAmount());
        if (this.currentRecipe.isMoldConsumed()) {
            this.moldInv.setStackInSlot(0, ItemStack.f_41583_);
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.2f, 0.5f);
        this.reset();
    }

    public boolean canProcess() {
        if (this.currentRecipe != null) {
            return this.inputTank.getFluidAmount() >= this.inputTank.getCapacity() && this.matchCastingRecipe(this.currentRecipe);
        }
        return false;
    }

    public ItemStack getRecipeOutput() {
        return this.lastOutput;
    }

    protected void spawnParticles() {
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.25f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, v.f_82479_, v.f_82480_ + 0.45, v.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public IFluidHandler getFluidTank() {
        return (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse((Object)new FluidTank(1));
    }

    public static boolean isInAirCurrent(Level level, BlockPos pos, BlockEntity be) {
        int range = 3;
        for (Direction direction : Direction.values()) {
            for (int i = 0; i <= range; ++i) {
                BlockPos nearbyPos = pos.m_5484_(direction, i);
                BlockState nearbyState = level.m_8055_(nearbyPos);
                if (!(nearbyState.m_60734_() instanceof EncasedFanBlock)) continue;
                EncasedFanBlockEntity fanBe = (EncasedFanBlockEntity)level.m_7702_(nearbyPos);
                Direction facing = (Direction)nearbyState.m_61143_((Property)EncasedFanBlock.FACING);
                BlockEntity facingBe = level.m_7702_(nearbyPos.m_5484_(facing, i));
                float flowDist = fanBe.airCurrent.maxDistance;
                if (be != facingBe || flowDist == 0.0f || !(flowDist >= (float)(i - 1))) continue;
                return true;
            }
        }
        return false;
    }

    protected <C extends Container> boolean matchCastingRecipe(Recipe<C> recipe) {
        if (recipe == null || !this.inv.getStackInSlot(0).m_41619_()) {
            return false;
        }
        return CastingRecipe.match(this, recipe);
    }

    public List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchCastingRecipe).sorted(Comparator.comparingInt(r -> r.m_7527_().size())).collect(Collectors.toList());
    }

    public int initProcess(FluidStack fluid, IFluidHandler.FluidAction action) {
        if (this.currentRecipe != null || this.running) {
            return 0;
        }
        this.fluidBuffer = fluid;
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return 0;
        }
        CastingRecipe recipe = (CastingRecipe)recipes.get(0);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.currentRecipe = recipe;
            this.lastOutput = this.currentRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
            this.sendData();
        }
        return recipe.getFluidIngredient().getRequiredAmount();
    }

    public void reset() {
        this.inputTank.reset();
        this.processingTick = -1;
        this.currentRecipe = null;
        this.running = false;
        this.lastOutput = ItemStack.f_41583_;
        this.sendData();
    }

    public FluidStack getFluidBuffer() {
        return this.fluidBuffer;
    }

    protected abstract <C extends Container> boolean matchStaticFilters(Recipe<C> var1);

    protected abstract Object getRecipeCacheKey();

    public static enum LockMode implements INamedIconOptions
    {
        UNLOCKED(AllIcons.I_CONFIG_UNLOCKED),
        LOCKED(AllIcons.I_CONFIG_LOCKED);

        private final String translationKey;
        private final AllIcons icon;

        private LockMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "createmetallurgy.casting.lock_mode." + CMLang.asId(this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

