/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipe;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public abstract class CastingAbstractCategory<T extends CastingRecipe>
extends CreateRecipeCategory<T> {
    public CastingAbstractCategory(CreateRecipeCategory.Info<T> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        FluidIngredient fluidIngredient = ((CastingRecipe)recipe).getFluidIngredient();
        CastingAbstractCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)15, (int)6, (FluidIngredient)fluidIngredient);
        Ingredient mold = ((CastingRecipe)recipe).getIngredient();
        if (!mold.m_43947_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 26).setBackground(CastingAbstractCategory.getRenderedSlot(), -1, -1).addIngredients(mold);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 139, 27).setBackground(CastingAbstractCategory.getRenderedSlot(), -1, -1).addItemStack(CastingAbstractCategory.getResultItem(recipe));
    }

    protected void drawCastingTime(T recipe, GuiGraphics graphics, int y) {
        int duration = ((CastingRecipe)recipe).getProcessingDuration();
        if (duration > 0) {
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{Float.valueOf((float)duration / 20.0f)}).m_130940_(ChatFormatting.GRAY);
            Font renderer = Minecraft.m_91087_().f_91062_;
            int stringWidth = renderer.m_92852_((FormattedText)timeString);
            graphics.m_280614_(renderer, (Component)timeString, 115 - stringWidth, y, 0xFFFFFF, false);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!((CastingRecipe)recipe).getIngredient().m_43947_() && ((CastingRecipe)recipe).isMoldConsumed()) {
            int minX = 14;
            int maxX = minX + 18;
            int minY = 44;
            int maxY = minY + 18;
            if (mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
                tooltip.add((Component)CMLang.translateDirect("recipe.casting.mold_consumed", new Object[0]).m_130940_(ChatFormatting.RED));
                return tooltip;
            }
        }
        return tooltip;
    }
}

